/*  Ermittelt die Arbeitstage für einen gegebenen Arbeitsplatz.
*/
SELECT tsystem.function__drop_by_regex( 'ksvba__get_workingdays', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ksvba__get_workingdays( _ksvba_id int ) returns integer[7] as $$
  DECLARE
      _ksv_record record;
      _days integer[];
  BEGIN

      -- returns data normalized to DOW of postgresql spec.
      -- 0 = Sunday
      -- 1 = Monday
      -- ...
      -- 5 = Friday
      -- 6 = Saturday

      SELECT
        ks_id, ks_abt, ks_ausw,
        ks_ka1, ks_ka2, ks_ka3, ks_ka4, ks_ka5, ks_ka6, ks_ka7
      INTO _ksv_record
      FROM ksv k
      JOIN ksvba ba ON k.ks_id = ba.ksb_ks_id
      WHERE ba.ksb_id = _ksvba_id;

      IF ( _ksv_record.ks_id IS NULL ) THEN
          RAISE EXCEPTION 'ksvba with id % not found', _ksvba_id;
      END IF;

      -- Im Kapazitätsstack-Algorithmus für KKS ...
      IF ( TSystem.Settings__GetBool( 'scheduling.algorithm_is_kapa_stack' ) AND scheduling.ksv__is_top_ksv__by__ks_abt( _ksv_record.ks_abt ) ) THEN
          -- ... sind alle Wochentage Arbeitstage.
          _days := array[0,1,2,3,4,5,6]::integer[];

      -- Für Auswärts-Kostenstellen ...
      ELSIF ( _ksv_record.ks_ausw ) THEN
          -- ... nehmen wir Mo bis Fr als Arbeitstage an.
          _days := array[1,2,3,4,5]::integer[];

      -- Standardmäßig ...
      ELSE
          -- ... sind die in der KSV mit Kapazität hinterlegten Tage Arbeitstage. (0=Sonntagg bis 6=Samstag)
          IF _ksv_record.ks_ka1 > 0 THEN _days := array_append(_days, 0); END IF; -- sonntag
          IF _ksv_record.ks_ka2 > 0 THEN _days := array_append(_days, 1); END IF; -- montag
          IF _ksv_record.ks_ka3 > 0 THEN _days := array_append(_days, 2); END IF;
          IF _ksv_record.ks_ka4 > 0 THEN _days := array_append(_days, 3); END IF;
          IF _ksv_record.ks_ka5 > 0 THEN _days := array_append(_days, 4); END IF;
          IF _ksv_record.ks_ka6 > 0 THEN _days := array_append(_days, 5); END IF;
          IF _ksv_record.ks_ka7 > 0 THEN _days := array_append(_days, 6); END IF; -- samstag

      END IF;

    RETURN _days;

  END $$ language plpgsql;
